/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
/*
TRUTHTABLE     : 

          ----------------------------
          D    clk   clrn  prn   q
          ----------------------------
                 _
          L    _/     H    H      L   
                 _
          H    _/     H    H      H  
                
          X     L     H    H      qo 
          
          X     X     L    H      L

          X     X     H    L      H

          X     X     L    L     illegal 

          ----------------------------- 
*/
`celldefine
`timescale 1ns / 100ps
module dff (q, d, clk, clrn, prn);
	parameter size =1;
	input
		d,
		clrn,
		prn,
		clk;
	output
		q;

	reg r_q;
	buf (q, r_q);

  	always @(posedge clk)
    	r_q = d;

  	always @(clrn or prn)
    	if (clrn == 0) 
        	assign r_q = 0;
    	else if (prn == 0)
            assign r_q = 1;
    	else
        	deassign r_q;

specify

	// Synthesis parameters
	`ifdef SYNTH
     	specparam area = 1;
     	specparam capacitance$clk = 1;
     	specparam capacitance$clrn = 1;
     	specparam capacitance$d = 1;
     	specparam capacitance$prn = 1;
	`endif

    // Timing Checks
    $hold(posedge clk,d,1.0);
    $setup(d,posedge clk,1.0);

    // Path Delays
       if (clrn && prn)
            (posedge clk => (q +: d)) = (1, 1);

       (negedge clrn => (q +: 1'b0)) = (1, 1);
       (negedge prn => (q +: 1'b1)) = (1, 1);

endspecify
endmodule
`endcelldefine
